/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network.config;

import com.ibm.hwmca.base.settings.network.config.DHCPServerRangeConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkApplicationConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkInterfaceConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkSettingsConfigParser;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class NetworkSettingsConfig
implements Serializable {
    private static final String TRACE_MASKT = "XSETNCFT";
    private static final String TRACE_MASKF = "XSETNCFF";
    private static final String TRACE_MASKD = "XSETNCFD";
    private static final String CONFIG_FILE_NAME = "network_config.xml";
    private static final String DEFAULT_CONFIG_FILE_PATH = "/opt/ccfw/data/network/";
    private ArrayList netApps = new ArrayList();
    private ArrayList netDevices = new ArrayList();
    private ArrayList dhcpServerRanges = new ArrayList();
    boolean remoteAccess = true;
    boolean offerLPARCheckbox = true;
    private String resourceBundleName = null;
    private transient ResourceBundle resourceBundle = null;
    private static NetworkSettingsConfig _settings = null;

    public static void main(String[] args) {
        try {
            System.out.println(new NetworkSettingsConfig(args[0]));
        }
        catch (MalformedXMLException exc) {
            exc.printStackTrace();
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    public static synchronized NetworkSettingsConfig getNetworkSettingsConfig() {
        Trace.trace(TRACE_MASKT, "-> NetworkSettingsConfig.getNetworkSettingsConfig()");
        if (_settings == null) {
            String filePath = null;
            try {
                filePath = BaseFileControl.getFilePath("networkconfig");
            }
            catch (HException exc) {
                Trace.trace(TRACE_MASKD, "Unable to locate network config dir: " + exc);
                Trace.trace(TRACE_MASKD, "Using default path/opt/ccfw/data/network/");
            }
            if (filePath == null) {
                filePath = DEFAULT_CONFIG_FILE_PATH;
            }
            filePath = filePath + CONFIG_FILE_NAME;
            try {
                _settings = new NetworkSettingsConfig(filePath);
            }
            catch (MalformedXMLException exc) {
                Trace.trace(TRACE_MASKD, "Unable to build NetworkSettingsConfig: " + exc);
                Trace.trace(TRACE_MASKD, "Using default config");
                _settings = new NetworkSettingsConfig();
            }
        }
        Trace.trace(TRACE_MASKT, "<- NetworkSettingsConfig.getNetworkSettingsConfig()");
        return _settings;
    }

    private NetworkSettingsConfig(String fileName) throws MalformedXMLException {
        this(new File(fileName));
    }

    private NetworkSettingsConfig(File file) throws MalformedXMLException {
        NetworkSettingsConfigParser.parseXML(file, this);
    }

    public NetworkSettingsConfig(ArrayList netApps, ArrayList netDevices, ArrayList dhcpServerRanges, boolean remoteAccess, boolean offerLPARCheckbox, String resourceBundleName) {
        this.netApps = netApps;
        this.netDevices = netDevices;
        this.dhcpServerRanges = dhcpServerRanges;
        this.setRemoteAccess(remoteAccess);
        this.setOfferLPARCheckbox(offerLPARCheckbox);
        this.setResourceBundleName(resourceBundleName);
    }

    private NetworkSettingsConfig() {
    }

    public void init() {
        this.netApps.clear();
        this.netDevices.clear();
        this.dhcpServerRanges.clear();
        this.setRemoteAccess(true);
        this.setOfferLPARCheckbox(true);
        this.setResourceBundleName(null);
    }

    public ArrayList getNetApps() {
        return this.netApps;
    }

    public NetworkApplicationConfig[] getNetAppsArray() {
        return this.netApps.toArray(new NetworkApplicationConfig[this.netApps.size()]);
    }

    public NetworkApplicationConfig getNetApp(String applicationID) {
        NetworkApplicationConfig curr = null;
        if (this.netApps != null && applicationID != null) {
            Iterator iterator = this.netApps.iterator();
            while (iterator.hasNext()) {
                curr = (NetworkApplicationConfig)iterator.next();
                if (applicationID.equals(curr.getApplicationID())) break;
                curr = null;
            }
        }
        return curr;
    }

    public void addNetApp(NetworkApplicationConfig netApp) {
        if (netApp != null) {
            String appId;
            NetworkApplicationConfig existingNetApp;
            if (this.resourceBundle != null) {
                netApp.setResourceBundle(this.resourceBundle);
            }
            if ((existingNetApp = this.getNetApp(appId = netApp.getApplicationID())) == null) {
                this.netApps.add(netApp);
            } else {
                this.netApps.set(this.netApps.indexOf(existingNetApp), netApp);
            }
        }
    }

    public ArrayList getNetworkInterfaces() {
        return this.netDevices;
    }

    public NetworkInterfaceConfig[] getNetworkInterfacesArray() {
        return this.netDevices.toArray(new NetworkInterfaceConfig[this.netDevices.size()]);
    }

    public NetworkInterfaceConfig getNetworkInterface(String interfaceID) {
        NetworkInterfaceConfig curr = null;
        if (this.netDevices != null && interfaceID != null) {
            Iterator iterator = this.netDevices.iterator();
            while (iterator.hasNext()) {
                curr = (NetworkInterfaceConfig)iterator.next();
                if (interfaceID.equals(curr.getInterfaceID())) break;
                curr = null;
            }
        }
        return curr;
    }

    public void addNetworkInterface(NetworkInterfaceConfig netDevice) {
        if (netDevice != null) {
            String intId = netDevice.getInterfaceID();
            NetworkInterfaceConfig existingNetDevice = this.getNetworkInterface(intId);
            if (existingNetDevice == null) {
                this.netDevices.add(netDevice);
            } else {
                this.netDevices.set(this.netDevices.indexOf(existingNetDevice), netDevice);
            }
        }
    }

    public ArrayList getDHCPServerRanges() {
        return this.dhcpServerRanges;
    }

    public DHCPServerRangeConfig[] getDHCPServerRangesArray() {
        return this.dhcpServerRanges.toArray(new DHCPServerRangeConfig[this.dhcpServerRanges.size()]);
    }

    public void addDHCPServerRange(DHCPServerRangeConfig range) {
        this.dhcpServerRanges.add(range);
    }

    public boolean isRemoteAccess() {
        return this.remoteAccess;
    }

    public void setRemoteAccess(boolean remoteAccess) {
        this.remoteAccess = remoteAccess;
    }

    public boolean isOfferLPARCheckbox() {
        return this.offerLPARCheckbox;
    }

    public void setOfferLPARCheckbox(boolean offerLPARCheckbox) {
        this.offerLPARCheckbox = offerLPARCheckbox;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
        this.resourceBundle = null;
        try {
            if (resourceBundleName != null) {
                this.resourceBundle = ResourceBundle.getBundle(resourceBundleName);
            }
        }
        catch (MissingResourceException exc) {
            // empty catch block
        }
        this.setApplicationResourceBundles();
    }

    private void setApplicationResourceBundles() {
        if (this.netApps != null && this.resourceBundle != null) {
            Iterator iterator = this.netApps.iterator();
            while (iterator.hasNext()) {
                NetworkApplicationConfig curr = (NetworkApplicationConfig)iterator.next();
                curr.setResourceBundle(this.resourceBundle);
            }
        }
    }

    public String toString() {
        int idx;
        StringBuffer sb = new StringBuffer(100);
        sb.append("net_apps(");
        if (this.netApps != null) {
            idx = 0;
            while (idx < this.netApps.size()) {
                if (idx != 0) {
                    sb.append(";");
                }
                sb.append(this.netApps.get(idx).toString());
                ++idx;
            }
        }
        sb.append(")\n");
        sb.append("devices(");
        if (this.netDevices != null) {
            idx = 0;
            while (idx < this.netDevices.size()) {
                if (idx != 0) {
                    sb.append(";");
                }
                sb.append(this.netDevices.get(idx).toString());
                ++idx;
            }
        }
        sb.append(")\n");
        sb.append("dhcpd_ranges(");
        if (this.dhcpServerRanges != null) {
            idx = 0;
            while (idx < this.dhcpServerRanges.size()) {
                if (idx != 0) {
                    sb.append(";");
                }
                sb.append(this.dhcpServerRanges.get(idx).toString());
                ++idx;
            }
        }
        sb.append(")\n");
        sb.append("remote(");
        sb.append(this.remoteAccess);
        sb.append(")\n");
        sb.append("offer_lpar_check(");
        sb.append(this.offerLPARCheckbox);
        sb.append(")\n");
        sb.append("res_bundle(");
        sb.append(this.resourceBundleName);
        sb.append(")");
        return sb.toString();
    }
}

